IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE]') AND type in (N'U'))
begin
CREATE TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_NF_ENT_FISCAL_ENVIO_PENDENTE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_ENVIO_PENDENTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_ENVIO_PENDENTE_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_ENVIO_PENDENTE_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_ENVIO_PENDENTE_DT_CAD]  DEFAULT ((0)) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_FISCAL_ENVIO_PENDENTE_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])
ON DELETE CASCADE

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_ENVIO_PENDENTE] CHECK CONSTRAINT [FK_EST_NF_ENT_FISCAL_ENVIO_PENDENTE_EST_NF_ENT]
end
